/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.sapience.util;

import com.google.common.collect.ImmutableList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class HoglinTasksHelper {
    private static final Tags.IOptionalNamedTag<Item> HOGLIN_FOOD_ITEMS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("sapience", "hoglin_food_items"));
    public static final int GROWING_ID = 12;
    public static final int BREEDING_ID = 18;

    private static boolean hasNearestRepllentMemory(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234098_af_);
    }

    private static boolean hasBreedTargetMemory(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_220953_n);
    }

    protected static boolean hasPacifiedMemory(HoglinEntity hoglinEntity) {
        return hoglinEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234099_ag_);
    }

    public static void registerCoreTasks(Brain<HoglinEntity> hoglinEntityBrain) {
        hoglinEntityBrain.func_233698_a_(Activity.field_221365_a, 0, HoglinTasksHelper.getCoreTasks());
    }

    private static ImmutableList<Task<? super HoglinEntity>> getCoreTasks() {
        return ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)new PickupWantedItemTask(1.0f, true, 9));
    }

    public static boolean canPickUpItemStack(AnimalEntity animalEntity, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d().func_203417_a((ITag)BlockTags.field_232879_au_)) {
            return false;
        }
        if (animalEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
            return false;
        }
        if (item.func_206844_a(HOGLIN_FOOD_ITEMS)) {
            return !HoglinTasksHelper.hasAteRecently(animalEntity);
        }
        return false;
    }

    public static void pickUpBreedingItem(AnimalEntity animalEntity, ItemEntity itemEntity) {
        animalEntity.func_71001_a((Entity)itemEntity, 1);
        ItemStack temptationStack = itemEntity.func_92059_d();
        ItemStack pickupStack = temptationStack.func_77979_a(1);
        if (temptationStack.func_190926_b()) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(temptationStack);
        }
        if (!HoglinTasksHelper.hasAteRecently(animalEntity)) {
            HoglinTasksHelper.setAteRecently(animalEntity);
        }
        int growingAge = animalEntity.func_70874_b();
        World animalWorld = animalEntity.field_70170_p;
        if (!animalWorld.field_72995_K && growingAge == 0 && !animalEntity.func_70880_s()) {
            animalEntity.func_146082_f(null);
        } else if (!animalWorld.field_72995_K && animalEntity.func_70631_g_()) {
            animalEntity.func_175501_a((int)((float)(-growingAge / 20) * 0.1f), true);
        }
    }

    private static boolean hasAteRecently(AnimalEntity animalEntity) {
        return animalEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_234097_ae_);
    }

    public static boolean isHoglinFoodItem(Item item) {
        return item.func_206844_a(HOGLIN_FOOD_ITEMS) || item == Items.field_234722_bw_;
    }

    public static void setAteRecently(AnimalEntity animalEntity) {
        animalEntity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234097_ae_, (Object)true, 200L);
    }
}

